import unittest
import test_davidson
import test_eval
import test_matvec
import test_random


def run_suite():
    suite = unittest.TestSuite()

    suite.addTest(test_davidson.DavidsonTest("test_benzene"))
    suite.addTest(test_davidson.DavidsonTest("test_benzene_null"))

    suite.addTest(test_eval.EvaluationTest("test_horner"))
    suite.addTest(test_eval.EvaluationTest("test_horner_matvec"))
    suite.addTest(test_eval.EvaluationTest("test_chebyshev"))
    suite.addTest(test_eval.EvaluationTest("test_chebyshev_shifted"))
    suite.addTest(test_eval.EvaluationTest("test_chebyshev_scaled"))
    suite.addTest(test_eval.EvaluationTest("test_chebyshev_gen"))
    suite.addTest(test_eval.EvaluationTest("test_chebyshev_gen_batch"))
    suite.addTest(test_eval.EvaluationTest("test_chebyshev_matvec"))
    suite.addTest(test_eval.EvaluationTest("test_chebyshev_matvec_gen"))
    suite.addTest(test_eval.EvaluationTest("test_chebyshev_matvec_batch"))

    suite.addTest(test_matvec.MatvecTest("test_benzene_full"))
    suite.addTest(test_matvec.MatvecTest("test_benzene_full_big"))
    suite.addTest(test_matvec.MatvecTest("test_benzene_proj"))

    suite.addTest(test_random.RandomTest("test_importance"))
    suite.addTest(test_random.RandomTest("test_importance_gen"))

    return suite


if __name__ == '__main__':
    runner = unittest.TextTestRunner()
    runner.run(run_suite())
