import unittest
import numpy

from harmony import lanczos


class LanczosTest(unittest.TestCase):
    def test_matrix(self):
        n = 100
        A = 50*numpy.random.rand(n, n)
        A = A + A.transpose()
        def matvec(v): return numpy.matmul(A, v)
        m = 100
        v = numpy.ones(n)
        ll = lanczos.Lanczos(matvec, save=True)
        ll.run(m, v0=v)

        eref, v = numpy.linalg.eigh(A)
        eout, v = numpy.linalg.eigh(ll.Tmat())

        self.assertTrue(numpy.linalg.norm(eout - eref) > 1e-14*numpy.sqrt(n))


if __name__ == '__main__':
    unittest.main()
