import unittest
import numpy

from omega.system import MolSystem
from omega.xtb_interface import XTBInterface

from harmony.harmonic import get_lowest_modes


class DavidsonTest(unittest.TestCase):
    def test_benzene(self):
        msys = MolSystem(filename="h5/Benzene_xtb.h5")
        computer = XTBInterface(None)
        Mi2 = 1.0/numpy.sqrt(numpy.asarray(msys.M))
        F2m = numpy.einsum('ij,i,j->ij', msys.F2, Mi2, Mi2)
        eref, _v = numpy.linalg.eigh(F2m)
        eout, _c = get_lowest_modes(msys, computer, 8)
        error = numpy.linalg.norm(eref[:8] - eout)
        msg = "Error in davidson: {}".format(error)
        self.assertTrue(error < 1e-7, msg)

    def test_benzene_null(self):
        msys = MolSystem(filename="h5/Benzene_xtb.h5")
        computer = XTBInterface(None)
        Mi2 = 1.0/numpy.sqrt(numpy.asarray(msys.M))
        F2m = numpy.einsum('ij,i,j->ij', msys.F2, Mi2, Mi2)
        eref, _v = numpy.linalg.eigh(F2m)
        eout, _c = get_lowest_modes(msys, computer, 8, ref=msys)
        error = numpy.linalg.norm(eref[:8] - eout)
        msg = "Error in davidson: {}".format(error)
        self.assertTrue(error < 1e-7, msg)


if __name__ == '__main__':
    unittest.main()
