from omega.system import MolSystem
from omega.pyscf_interface import PyscfInterface, Options

# Use this script to generate or regenerate the .h5 files
# in the h5/ directory
files = ["Benzene_b3lyp_sto3g", "h2o_hf_ccpvtz"]

for f in files:
    sys = MolSystem(filename="xyz/" + f + ".xyz")
    name, method, basis = f.split("_")
    print(name, method, basis)
    op = Options()
    op.method = method
    op.basis = basis
    op.scf_conv = 1e-10
    computer = PyscfInterface(op)
    sys.compute_forces(computer)
    sys.get_normal_modes()
    sys.save("h5/" + f + ".h5")
