import numpy
from omega.system import MolSystem
from omega.transrot import half_projector_against
from omega.transrot import transrot
from harmony.random import get_random

# just a quick benchmark
T = 298.15
sys = MolSystem(filename="h5/Benzene_b3lyp_sto3g.h5")

linear = sys.linear
dvecs = transrot(
        sys.mol.natom, sys.mol.coords, sys.I, sys.R,
        linear=sys.linear, masses=sys.M, mweight=True)

Uv = half_projector_against(dvecs)

# form mass-weighted Hessian
Mi2 = 1.0/numpy.sqrt(numpy.asarray(sys.M))
F2m = numpy.einsum('ij,i,j->ij', sys.F2, Mi2, Mi2)

# project out translations and rotations
F2mv = numpy.einsum('pi,qj,pq->ij', Uv, Uv, F2m)
n = F2mv.shape[0]

nsample = 1000
nbench = 20
#method = "Rademacher"
#method = "Gaussian"
method = "Rayleigh"

for i in range(nbench):
    approx = 0.0
    for i in range(nsample):
        v = get_random(n, method=method)
        approx += numpy.einsum('i,ij,j->', v, F2mv, v)/float(nsample)

    actual = numpy.trace(F2mv)
    diff = abs(actual - approx)/abs(actual)
    print("{:.6f} {:.6f} {:.10f}".format(actual, approx, diff))
