import logging
import sys
from omega.system import MolSystem
from omega.pyscf_interface import PyscfInterface, Options
from harmony.harmonic_potential import HarmonicPotential

# just a quick benchmark
T = 298.15
msys = MolSystem(filename="h5/Benzene_b3lyp_sto3g.h5")
ref = MolSystem(filename="h5/Benzene_xtb.h5")
logging.basicConfig(
    format='%(levelname)s:%(message)s', level=logging.INFO, stream=sys.stdout)

op = Options()
op.method = "b3lyp"
op.charge = 0
op.spin = 0
op.basis = "sto3g"
computer = PyscfInterface(op)

driver = HarmonicPotential(msys, ref, computer)
params = {"cutoff": 50}
driver.run(
    params, quantities=["ZPE", "Hvib", "Svib"], nsample=36, method="Gaussian")
