import numpy
from omega.system import MolSystem
from omega.pyscf_interface import PyscfInterface, Options

from harmony.harmonic import get_matvec

T = 298.15
sys = MolSystem(filename="h5/Benzene_b3lyp_sto3g.h5")
Mi2 = 1.0/numpy.sqrt(numpy.asarray(sys.M))
n = len(Mi2)
F2m = numpy.einsum('ij,i,j->ij', sys.F2, Mi2, Mi2)
op = Options()
op.method = "b3lyp"
op.basis = "sto3g"
op.scf_conv = 1e-10
computer = PyscfInterface(op)

for delta in [0.01, 0.005, 0.001, 0.0005, 0.0001]:
    matvec = get_matvec(sys.mol, computer, delta=delta)

    vec = 2*numpy.random.rand(n) - numpy.ones(n)
    ref = numpy.einsum('ij,j->i', F2m, vec)
    out = matvec(vec)
    diff = numpy.linalg.norm(out - ref)/numpy.linalg.norm(ref)
    print("{:.5f}: {}".format(delta, diff))
