import numpy
from omega.system import MolSystem
from omega import constants
from omega.transrot import half_projector_against
from omega.transrot import transrot
from harmony.evaluation import eval_horner
from harmony.fit import chebyshev_fit, zpe, Afunc, Hfunc, Sfunc

# Just a script to generate some quick data
T = 298.15
sys = MolSystem(filename="h5/Benzene_b3lyp_sto3g.h5")
omega2 = sys.P2.diagonal()
omega = numpy.sqrt(omega2)
natom = sys.mol.natom
kBT = T*constants.kb / constants.hartree_to_ev
beta = 1.0 / (kBT + 1e-14)
ex = numpy.exp(-omega*beta)
Hvib = (omega*ex/(1.0 - ex)).sum()
Avib = (numpy.log(1.0 - ex)).sum()/beta
Svib = (Hvib - Avib)*beta
zperef = omega.sum()/2.0
kb_ha = constants.kb/constants.hartree_to_ev
print(zperef, Avib, Hvib, Svib)

linear = sys.linear
dvecs = transrot(
    sys.mol.natom, sys.mol.coords, sys.I, sys.R,
    linear=sys.linear, masses=sys.M, mweight=True)

Uv = half_projector_against(dvecs, full=True)

# form mass-weighted Hessian
Mi2 = 1.0/numpy.sqrt(numpy.asarray(sys.M))
F2m = numpy.einsum('ij,i,j->ij', sys.F2, Mi2, Mi2)

wmax = 8000/constants.hartree_to_cm_1
wmin = 250/constants.hartree_to_cm_1


def Hfunc2(x): return Hfunc(x, beta)


def Afunc2(x): return Afunc(x, beta)


def Sfunc2(x): return Sfunc(x, beta)


# loop over order of Chebyshev polynomials
print("#order   ZPE   H    A    S   S2")
for o in range(2, 64, 2):
    pzpe = chebyshev_fit(zpe, wmin, wmax, order=o, nx=1000)
    pA = chebyshev_fit(Afunc2, wmin, wmax, order=o, nx=1000)
    pH = chebyshev_fit(Hfunc2, wmin, wmax, order=o, nx=1000)
    pS = chebyshev_fit(Sfunc2, wmin, wmax, order=o, nx=1000)
    azpe = eval_horner(
        F2m, pzpe.convert(kind=numpy.polynomial.Polynomial).coef)
    aA = eval_horner(F2m, pA.convert(kind=numpy.polynomial.Polynomial).coef)
    aH = eval_horner(F2m, pH.convert(kind=numpy.polynomial.Polynomial).coef)
    aS = eval_horner(F2m, pS.convert(kind=numpy.polynomial.Polynomial).coef)

    ozpe = numpy.trace(numpy.einsum('pi,qj,pq->ij', Uv, Uv, azpe))
    oA = numpy.trace(numpy.einsum('pi,qj,pq->ij', Uv, Uv, aA))
    oH = numpy.trace(numpy.einsum('pi,qj,pq->ij', Uv, Uv, aH))
    oS = numpy.trace(numpy.einsum('pi,qj,pq->ij', Uv, Uv, aS))
    oS2 = beta*(oH - oA)
    print("{:4d}: {:10.6f} {:10.6f} {:10.6f} {:10.6f} {:10.6f}".format(
        o, ozpe - zperef, oA - Avib, oH - Hvib, oS - Svib, oS2 - Svib))
