import numpy
from omega.finite_difference import fd_hess_on_vec


def get_matvec_proj(P, mol, computer, delta=0.0012, diff="sym"):
    gc = None
    if diff.lower() != "sym":
        Ec, gc = computer.gradient(mol)

    def matvec(vec):
        norm = numpy.linalg.norm(vec)
        temp = vec/norm
        x = numpy.matmul(P, temp)
        x = fd_hess_on_vec(mol, computer, x, mweight=True, delta=delta, method=diff, gc=gc)
        return norm*numpy.matmul(P, x)

    return matvec


def get_matvec_half_proj(Ph, mol, computer, delta=0.0012, diff="sym"):
    gc = None
    if diff.lower() != "sym":
        Ec, gc = computer.gradient(mol)

    def matvec(vec):
        norm = numpy.linalg.norm(vec)
        temp = vec/norm
        x = numpy.matmul(Ph, temp)
        x = fd_hess_on_vec(mol, computer, x, mweight=True, delta=delta, method=diff, gc=gc)
        return norm*numpy.matmul(Ph.transpose(), x)

    return matvec


def get_matvec(mol, computer, delta=0.0012, diff="sym"):
    gc = None
    if diff.lower() != "sym":
        Ec, gc = computer.gradient(mol)

    def matvec(vec):
        norm = numpy.linalg.norm(vec)
        if norm < 1e-10:
            return numpy.zeros((vec.shape))
        temp = vec/norm
        return norm*fd_hess_on_vec(mol, computer, temp, mweight=True, delta=delta, method=diff, gc=gc)

    return matvec
