import numpy


class Lanczos(object):
    """A class for performing the Lanczos algorithm"""
    def __init__(self, matvec, save=False, full=True):
        self.matvec = matvec
        self.save = save
        self._vmat = None
        self._As = []
        self._Bs = []
        self.full = full

    def run(self, m, v0=None):
        if v0 is None:
            pass
            #v0 = random
        n = v0.shape[0]
        v = v0/numpy.linalg.norm(v0)
        wp = self.matvec(v)
        a = numpy.dot(numpy.conj(wp), v)
        w = wp - a*v
        vj = v.copy()
        self._As.append(a)
        vmat = numpy.zeros((m, n))
        vmat[0] = v
        for j in range(1, m):
            b = numpy.linalg.norm(w)
            #if b < thresh: raise Exception("Zero norm")
            v = w/b
            vmat[j] = v
            wp = self.matvec(v)
            a = numpy.dot(numpy.conj(wp), v)
            if self.full:
                w = wp - numpy.matmul(vmat.transpose(), numpy.matmul(vmat, wp))
            else:
                w = wp - a*v - b*vj
            vj = v.copy()
            self._As.append(a)
            self._Bs.append(b)

        assert(len(self._As) == m)
        assert(len(self._Bs) == m - 1)
        if self.save:
            self._vmat = vmat

    def Tmat(self):
        m = len(self._As)
        if m == 0:
            raise Exception("Cannot construct T matrix, run Lanczos first.")
        T = numpy.zeros((m, m))
        for i in range(m):
            T[i, i] = self._As[i]
            if i > 0:
                T[i, i-1] = T[i-1, i] = self._Bs[i - 1]
        return T
