import numpy
from .random import get_random
has_pyscf = True
try:
    from pyscf.lib.linalg_helper import davidson as pyscf_davidson
except ImportError:
    has_pyscf = False


def davidson(nroots, n, matvec, max_cycle=100):
    x0 = []
    for i in range(nroots):
        x = get_random(n, "Rayleigh")
        x0.append(x/numpy.linalg.norm(x))

    if has_pyscf:
        def apply_precond(vec, p1, p2):
            return vec
        precond = apply_precond
        return pyscf_davidson(
            matvec, x0, precond, nroots=nroots,
            max_cycle=max_cycle, max_space=4*nroots, tol=1e-20)
    else:
        raise Exception("PySCF is required for Davidson calculation")
