"""This script computes the zero-point energy, entropy (TS in Hartrees), and 
enthalpy by exactly computing chebyshev fit.
"""
import logging
import sys
from omega.system import *
from omega import constants
from omega.xtb_interface import XTBInterface

from harmony.harmonic import Harmonic

logging.basicConfig(format='%(levelname)s:%(message)s', level=logging.INFO, stream=sys.stdout)
msys = MolSystem(filename="cholesterol.xyz")
T = 298.15

computer = XTBInterface(None)
fit_params = {"order" : 21, "wmin" : 10, "wmax" : 4000, "cutoff": 50}
calc = Harmonic(msys, computer)
Z, H, S = calc.run_exact(fit_params, quantities=["ZPE", "Hvib", "Svib"])
print("Output: {:13.10f} {:13.10f} {:13.10f}".format(Z, H, S))
