"""This script computes the entropy (TS in Hartrees) by
Chebyshev fitting and stochastic sampling with Hutch++
"""
import logging
import sys
from omega.system import *
from omega import constants
from omega.xtb_interface import XTBInterface

from harmony.harmonic import Harmonic

logging.basicConfig(format='%(levelname)s:%(message)s', level=logging.INFO, stream=sys.stdout)
msys = MolSystem(filename="cholesterol.xyz")
T = 298.15

computer = XTBInterface(None)
fit_params = {"order" : 21, "wmin" : 10, "wmax" : 4000, "cutoff": 50}
calc = Harmonic(msys, computer)
S = calc.run(fit_params, nsample=20, quantities=["Svib"], method="hutch++")[0]
print("Output: {:13.10f}".format(S))
