"""This script computes the entropy (TS in Hartrees) by
Chebyshev fitting and stochastic sampling.
"""
import logging
import sys
from omega.system import *
from omega import constants
from omega.xtb_interface import XTBInterface

from harmony.harmonic import Harmonic

logging.basicConfig(format='%(levelname)s:%(message)s', level=logging.INFO, stream=sys.stdout)
msys = MolSystem(filename="cholesterol.xyz")
T = 298.15

computer = XTBInterface(None)
fit_params = {
    "order" : 21,  # order of chebyshev expansion
    "wmin" : 10,  # minimum frequency (in wavenumbers)
    "wmax" : 4000,  # maximum frequency (in wavenubers)
    "cutoff": 50}  # Cutoff for low-frequency modes (wavenumbers)
calc = Harmonic(msys, computer)
S = calc.run(fit_params, nsample=60, quantities=["Svib"])[0]
print("Output: {:13.10f}".format(S))
