import logging
import sys
from omega.system import *
from omega import constants
from omega.xtb_interface import XTBInterface, Options

from harmony.harmonic import HarmonicBinding

logging.basicConfig(format='%(levelname)s:%(message)s', level=logging.INFO, stream=sys.stdout)

msys = MolSystem(filename="../PL.xyz")
msys1 = MolSystem(filename="../P.xyz")
msys2 = MolSystem(filename="../L.xyz")
T = 298.15
kB = constants.kb / constants.hartree_to_ev

op = Options()
op.solvent = "h2o"
computer = XTBInterface(op)

calc = HarmonicBinding(msys, msys1, msys2, computer)
fit_params = {
        "order" : 8,
        "cutoff" : 50}

Z,H,S = calc.run(fit_params, fit="Lanczos", quantities=["ZPE","Hvib","Svib"], T=T, nsample=2, diff="forward", full=True)
for z,h,s in zip(Z,H,S):
    print("{:14.10f}  {:14.10f}  {:14.10f}".format(z,h,s))
