import logging
import sys
from omega.system import *
from omega import constants
from omega.xtb_interface import XTBInterface, Options
from xtb.interface import Param

from harmony.harmonic import Harmonic

logging.basicConfig(format='%(levelname)s:%(message)s', level=logging.INFO, stream=sys.stdout)

T = 298.15
computer = XTBInterface(None)
sys = MolSystem(filename="np333.xyz")

fit_params = {"order" : 16, "wmin" : 10, "wmax" : 4500, "cutoff": 50, "points": "quadratic", "nx" : 2000}
calc = Harmonic(sys, computer)

Z,H,S = calc.run(fit_params, fit='Lanczos', quantities=["ZPE", "Hvib", "Svib"], nsample=5)
print("Z: {:13.10f}".format(Z))
print("H: {:13.10f}".format(H))
print("S: {:13.10f}".format(S))
